<?php $__env->startSection('content'); ?>
<head>
    <style>
        body {
            margin: 0;
            font-family: 'Segoe UI', Arial, sans-serif;
            background: #000;
            color: #fff;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            min-height: 100vh;
        }

        .tiktok-container {
            width: 100%;
            max-width: 420px;
            padding: 0;
        }

        /* Header bar */
        .top-bar {
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            height: 55px;
            border-bottom: 1px solid #222;
            background: #111;
        }

        .top-bar .back-btn {
            position: absolute;
            left: 15px;
            font-size: 20px;
            color: #fff;
            text-decoration: none;
        }

        .top-bar .title {
            font-size: 17px;
            font-weight: 600;
        }

        .form-box {
            background: #111;
            padding: 50px 25px 35px 25px;
            border-radius: 18px;
            box-shadow: 0 0 15px rgba(0,0,0,0.7);
            text-align: center;
            position: relative;
            margin: 100px 15px 20px 15px; /* 👉 lebih turun */
        }

        /* Logo separuh keluar */
        .logo-wrap {
            width: 90px;
            height: 90px;
            border-radius: 50%;
            border: 3px solid #fe2c55;
            background: #000;
            display: flex;
            align-items: center;
            justify-content: center;
            position: absolute;
            top: -45px;
            left: 50%;
            transform: translateX(-50%);
        }

        .tiktok-logo {
            width: 55px;
            height: 55px;
            object-fit: contain;
        }

        .tab-switch {
            display: flex;
            margin-bottom: 25px;
            border-bottom: 1px solid #222;
            margin-top: 20px;
        }

        .tab-switch a {
            flex: 1;
            text-align: center;
            padding: 14px 0;
            font-size: 16px;
            color: #888;
            text-decoration: none;
        }

        .tab-switch a.active {
            color: #fe2c55;
            border-bottom: 2px solid #fe2c55;
            font-weight: 600;
        }

        .input-wrap {
            margin-bottom: 18px;
        }

        .login-input {
            display: block;
            width: 100%;
            height: 48px;
            border: 1px solid #333;
            border-radius: 12px;
            padding: 0 15px;
            font-size: 15px;
            outline: none;
            background: #000;
            color: #fff;
            transition: border 0.2s, background 0.2s;
            box-sizing: border-box;
        }

        .login-input:focus {
            border-color: #fe2c55;
            background: #1a1a1a;
        }

        .login-btn {
            width: 100%;
            height: 48px;
            background: #fe2c55;
            border: none;
            border-radius: 12px;
            color: #fff;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            margin-top: 8px;
            transition: background 0.25s;
        }

        .login-btn:hover {
            background: #e0254b;
        }

        .divider {
            text-align: center;
            margin: 22px 0;
            font-size: 13px;
            color: #777;
            position: relative;
        }

        .divider::before,
        .divider::after {
            content: "";
            position: absolute;
            top: 50%;
            width: 40%;
            border-top: 1px solid #222;
        }
        .divider::before { left: 0; }
        .divider::after { right: 0; }

        .switch-link {
            text-align: center;
            font-size: 14px;
            color: #aaa;
            margin-top: 10px;
        }

        .switch-link a {
            color: #fe2c55;
            font-weight: 500;
            text-decoration: none;
        }
    </style>
</head>
<body>
<div class="tiktok-container">

    <!-- Header atas -->
    <div class="top-bar">
        <a href="<?php echo e(url('/')); ?>" class="back-btn">&#8592;</a>
        <div class="title">Masuk</div>
    </div>

    <div class="form-box">
        <!-- Logo TikTok separuh masuk -->
        <div class="logo-wrap">
            <img src="<?php echo e(asset('core/img/tiktok.jpg')); ?>" alt="TikTok" class="tiktok-logo">
        </div>

        <!-- Tab Login/Register -->
        <div class="tab-switch">
            <a href="<?php echo e(route('user.login')); ?>" class="active">Masuk</a>
            <a href="<?php echo e(route('user.register')); ?>">Daftar</a>
        </div>

        <!-- Form Login -->
        <form action="<?php echo e(route('user.login')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="input-wrap">
                <input type="text" name="username" placeholder="Masukan Nomor Telepon Anda" class="login-input">
            </div>

            <div class="input-wrap">
                <input type="password" name="password" placeholder="Masukan Kata sandi" class="login-input">
            </div>

            <button type="submit" class="login-btn">Masuk</button>
        </form>

        <div class="divider">ATAU</div>

        <div class="switch-link">
            Belum punya akun? <a href="<?php echo e(route('user.register')); ?>">Daftar</a>
        </div>
    </div>
</div>
</body>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($activeTemplate.'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aureustweb/affiliate.finexa.biz.id/core/resources/views/templates/invester/user/auth/login.blade.php ENDPATH**/ ?>