<?php
    $planList = \App\Models\Plan::whereHas('timeSetting', function ($time) {
        $time->where('status', 1);
    })
        ->where('status', 1)
        ->orderBy('id', 'desc')
        ->get();
    $calculationContent = getContent('calculation.content', true);
?>

<!-- profit-calculator-section start -->
<section class="profit-calculator-section pb-150 pt-150">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8">
                <div class="profit-calculator-wrapper">
                    <h2 class="title"><?php echo e(__(@$calculationContent->data_values->heading)); ?></h2>
                    <p class="mb-4"><?php echo e(__(@$calculationContent->data_values->sub_heading)); ?></p>

                    <form class="profit-calculator-form exchange-form">
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label><?php echo app('translator')->get('Plan'); ?></label>
                                <select id="changePlan" class="form-control">
                                    <?php $__currentLoopData = $planList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($data->id); ?>" data-fixed_amount="<?php echo e($data->fixed_amount); ?>" data-minimum_amount="<?php echo e($data->minimum); ?>" data-maximum_amount="<?php echo e($data->maximum); ?>"><?php echo e($data->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="form-group col-md-6">
                                <label><?php echo app('translator')->get('Invest Amount'); ?> <span class="invest-range"></span></label>
                                <input type="text" placeholder="0.00" class="invest-input form-control" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')">
                            </div>


                            <div class="form-group col-md-12">
                                <h5 class="profit-input base--color"></h5>
                                <code class="period"></code>
                            </div>

                        </div>
                    </form>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="profit-thumb">
                    <img src="<?php echo e(getImage('assets/images/frontend/calculation/' . @$calculationContent->data_values->image)); ?>" alt="image">
                </div>
            </div>
        </div>
    </div>
</section>
<!-- profit-calculator-section end -->

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $(document).ready(function() {
                var curSym = '<?php echo e($general->cur_sym); ?>';
                $("#changePlan").on('change', function() {
                    var selectedPlan = $('#changePlan').find(':selected');
                    var planId = selectedPlan.val();
                    var data = selectedPlan.data();
                    var fixedAmount = parseFloat(data.fixed_amount).toFixed(2);
                    var minimumAmount = parseFloat(data.minimum_amount).toFixed(2);
                    var maximumAmount = parseFloat(data.maximum_amount).toFixed(2);

                    if (fixedAmount > 0) {
                        $('.invest-input').val(fixedAmount);
                        $('.invest-input').attr('readonly', true);
                        $('.invest-range').text('');
                    } else {
                        $('.invest-input').val(minimumAmount);
                        $('.invest-input').attr('readonly', false);
                        $('.invest-range').text('(' + curSym + minimumAmount + ' - ' + curSym + maximumAmount + ')');
                    }

                    var investAmount = $('.invest-input').val();
                    var profitInput = $('.profit-input').text('');

                    $('.period').text('');

                    if (investAmount != '' && planId != null) {
                        ajaxPlanCalc(planId, investAmount)
                    }
                }).change();

                $(".invest-input").on('change', function() {
                    var planId = $("#changePlan option:selected").val();
                    var investAmount = $(this).val();
                    var profitInput = $('.profit-input').text('');
                    $('.period').text('');
                    if (investAmount != '' && planId != null) {
                        ajaxPlanCalc(planId, investAmount)
                    }
                });
            });

            function ajaxPlanCalc(planId, investAmount) {
                $.ajax({
                    url: "<?php echo e(route('planCalculator')); ?>",
                    type: "post",
                    data: {
                        planId,
                        _token: '<?php echo e(csrf_token()); ?>',
                        investAmount
                    },
                    success: function(response) {
                        var alertStatus = "<?php echo e($general->alert); ?>";
                        if (response.errors) {
                            iziToast.error({
                                message: response.errors,
                                position: "topRight"
                            });
                        } else {
                            var msg = `${response.description}`
                            $('.profit-input').text(msg);
                            if (response.netProfit) {
                                $('.period').text('Net Profit ' + response.netProfit);
                            }
                        }
                    }
                });
            }
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/xam/phemex.xa-m.pro/core/resources/views/templates/neo_dark/sections/calculation.blade.php ENDPATH**/ ?>