<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5><?php echo app('translator')->get('Manage Bonus'); ?></h5>
        <a href="<?php echo e(route('admin.bonus.create')); ?>" class="btn btn-primary"><?php echo app('translator')->get('Add Bonus'); ?></a>
    </div>
    <div class="card-body">
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('ID'); ?></th>
                    <th><?php echo app('translator')->get('Bonus Name'); ?></th>
                    <th><?php echo app('translator')->get('Code'); ?></th>
                    <th><?php echo app('translator')->get('Amount'); ?></th>
                    <th><?php echo app('translator')->get('Status'); ?></th>
                    <th><?php echo app('translator')->get('Actions'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bonus): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($bonus->id); ?></td>
                    <td><?php echo e($bonus->bonus_name); ?></td>
                    <td><?php echo e($bonus->code); ?></td>
                    <td><?php echo e($bonus->amount); ?></td>
                    <td><?php echo e($bonus->status); ?></td>
                    <td class="d-flex gap-1">
                        <a href="<?php echo e(route('admin.bonus.status', $bonus->id)); ?>" class="btn btn-sm btn-success"><?php echo app('translator')->get('Activate'); ?></a>
                        <a href="<?php echo e(route('admin.bonus.create', $bonus->id)); ?>" class="btn btn-sm btn-warning"><?php echo app('translator')->get('Edit'); ?></a>
                        <form action="<?php echo e(route('admin.bonus.delete', $bonus->id)); ?>" method="POST" style="display:inline-block;">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button class="btn btn-sm btn-danger" type="submit" onclick="return confirm('<?php echo app('translator')->get('Are you sure?'); ?>')"><?php echo app('translator')->get('Delete'); ?></button>
                        </form>
                        <a href="<?php echo e(route('admin.bonus.view', $bonus->id)); ?>" class="btn btn-sm btn-info"><?php echo app('translator')->get('View'); ?></a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nicelivingweb/public_html/core/resources/views/admin/pages/bonus/index.blade.php ENDPATH**/ ?>