<?php $__env->startSection('content'); ?>
<head>
    <style>
        body {
            margin: 0;
            font-family: 'Segoe UI', Arial, sans-serif;
            background: #000;
            color: #fff;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            min-height: 100vh;
        }

        .tiktok-container {
            width: 100%;
            max-width: 420px;
            padding: 0;
        }

        /* Header bar */
        .top-bar {
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            height: 55px;
            border-bottom: 1px solid #222;
            background: #111;
        }

        .top-bar .back-btn {
            position: absolute;
            left: 15px;
            font-size: 20px;
            color: #d4af37;
            text-decoration: none;
        }

        .top-bar .title {
            font-size: 17px;
            font-weight: 600;
            color: #d4af37;
        }

        .form-box {
            background: #111;
            padding: 50px 25px 35px 25px;
            border-radius: 18px;
            box-shadow: 0 0 20px rgba(212, 175, 55, 0.2);
            text-align: center;
            position: relative;
            margin: 100px 15px 20px 15px;
        }

        .logo-wrap {
            width: 90px;
            height: 90px;
            border-radius: 50%;
            border: 3px solid #d4af37;
            background: #000;
            display: flex;
            align-items: center;
            justify-content: center;
            position: absolute;
            top: -45px;
            left: 50%;
            transform: translateX(-50%);
        }

        .tiktok-logo {
            width: 55px;
            height: 55px;
            object-fit: contain;
            filter: brightness(1.1);
        }

        .tab-switch {
            display: flex;
            margin-bottom: 25px;
            border-bottom: 1px solid #333;
            margin-top: 20px;
        }

        .tab-switch a {
            flex: 1;
            text-align: center;
            padding: 14px 0;
            font-size: 16px;
            color: #888;
            text-decoration: none;
            transition: color 0.2s, border 0.2s;
        }

        .tab-switch a.active {
            color: #d4af37;
            border-bottom: 2px solid #d4af37;
            font-weight: 600;
        }

        .tab-switch a:hover {
            color: #b89623;
        }

        .input-wrap {
            margin-bottom: 18px;
        }

        .login-input {
            display: block;
            width: 100%;
            height: 48px;
            border: 1px solid #333;
            border-radius: 12px;
            padding: 0 15px;
            font-size: 15px;
            outline: none;
            background: #000;
            color: #fff;
            transition: border 0.2s, background 0.2s;
            box-sizing: border-box;
        }

        .login-input:focus {
            border-color: #d4af37;
            background: #1a1a1a;
        }

        .login-btn {
            width: 100%;
            height: 48px;
            background: #d4af37;
            border: none;
            border-radius: 12px;
            color: #000;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            margin-top: 8px;
            transition: background 0.25s, color 0.25s;
        }

        .login-btn:hover {
            background: #b89623;
            color: #fff;
        }

        .divider {
            text-align: center;
            margin: 22px 0;
            font-size: 13px;
            color: #aaa;
            position: relative;
        }

        .divider::before,
        .divider::after {
            content: "";
            position: absolute;
            top: 50%;
            width: 40%;
            border-top: 1px solid #222;
        }

        .divider::before { left: 0; }
        .divider::after { right: 0; }

        .switch-link {
            text-align: center;
            font-size: 14px;
            color: #ccc;
            margin-top: 10px;
        }

        .switch-link a {
            color: #d4af37;
            font-weight: 500;
            text-decoration: none;
        }

        .switch-link a:hover {
            color: #b89623;
        }
    </style>
</head>
<body>
<div class="tiktok-container">

    <!-- Header atas -->
    <div class="top-bar">
        <a href="<?php echo e(url('/')); ?>" class="back-btn">&#8592;</a>
        <div class="title">Masuk</div>
    </div>

    <div class="form-box">
        <div class="logo-wrap">
            <img src="<?php echo e(asset('core/img/tiktok.jpg')); ?>" alt="TikTok" class="tiktok-logo">
        </div>

        <div class="tab-switch">
            <a href="<?php echo e(route('user.login')); ?>" class="active">Masuk</a>
            <a href="<?php echo e(route('user.register')); ?>">Daftar</a>
        </div>

        <form action="<?php echo e(route('user.login')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="input-wrap">
                <input type="text" name="username" placeholder="Masukan Nomor Telepon Anda" class="login-input">
            </div>

            <div class="input-wrap">
                <input type="password" name="password" placeholder="Masukan Kata sandi" class="login-input">
            </div>

            <button type="submit" class="login-btn">Masuk</button>
        </form>

        <div class="divider">ATAU</div>

        <div class="switch-link">
            Belum punya akun? <a href="<?php echo e(route('user.register')); ?>">Daftar</a>
        </div>
    </div>
</div>
</body>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($activeTemplate.'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aureustweb/affiliate-center.biz.id/core/resources/views/templates/invester/user/auth/login.blade.php ENDPATH**/ ?>