<?php $__env->startSection('content'); ?>
    <section class="dashboard-section pt-120 pb-120">
        <div class="container">
            <div class="row justify-content-center">

                <div class="col-md-12">
                    <?php if($user->deposit_wallet <= 0 && $user->interest_wallet <= 0): ?>
                        <div class="alert border border--danger" role="alert">
                            <div class="alert__icon d-flex align-items-center text--danger"><i
                                    class="fas fa-exclamation-triangle"></i></div>
                            <p class="alert__message">
                                <span class="fw-bold"><?php echo app('translator')->get('Empty Balance'); ?></span><br>
                                <small><i><?php echo app('translator')->get('Your balance is empty. Please make'); ?> <a href="<?php echo e(route('user.deposit.index')); ?>"
                                            class="link-color"><?php echo app('translator')->get('deposit'); ?></a> <?php echo app('translator')->get('for your next investment.'); ?></i></small>
                            </p>
                        </div>
                    <?php endif; ?>

                    <?php if($user->deposits->where('status', 1)->count() == 1 && !$user->invests->count()): ?>
                        <div class="alert border border--success" role="alert">
                            <div class="alert__icon d-flex align-items-center text--success"><i class="fas fa-check"></i>
                            </div>
                            <p class="alert__message">
                                <span class="fw-bold"><?php echo app('translator')->get('First Deposit'); ?></span><br>
                                <small><i><span class="fw-bold"><?php echo app('translator')->get('Congratulations!'); ?></span> <?php echo app('translator')->get('You\'ve made your first deposit successfully. Go to'); ?> <a
                                            href="<?php echo e(route('plan')); ?>" class="link-color"><?php echo app('translator')->get('investment plan'); ?></a>
                                        <?php echo app('translator')->get('page and invest now'); ?></i></small>
                            </p>
                        </div>
                    <?php endif; ?>

                    <?php if($pendingWithdrawals): ?>
                        <div class="alert border border--primary" role="alert">
                            <div class="alert__icon d-flex align-items-center text--primary"><i class="fas fa-spinner"></i>
                            </div>
                            <p class="alert__message">
                                <span class="fw-bold"><?php echo app('translator')->get('Withdrawal Pending'); ?></span><br>
                                <small><i><?php echo app('translator')->get('Total'); ?> <?php echo e(showAmount($pendingWithdrawals)); ?> <?php echo e($general->cur_text); ?>

                                        <?php echo app('translator')->get('withdrawal request is pending. Please wait for admin approval. The amount will send to the account which you\'ve provided. See'); ?> <a href="<?php echo e(route('user.withdraw.history')); ?>"
                                            class="link-color"><?php echo app('translator')->get('withdrawal history'); ?></a></i></small>
                            </p>
                        </div>
                    <?php endif; ?>

                    <?php if($pendingDeposits): ?>
                        <div class="alert border border--primary" role="alert">
                            <div class="alert__icon d-flex align-items-center text--primary"><i class="fas fa-spinner"></i>
                            </div>
                            <p class="alert__message">
                                <span class="fw-bold"><?php echo app('translator')->get('Deposit Pending'); ?></span><br>
                                <small><i><?php echo app('translator')->get('Total'); ?> <?php echo e(showAmount($pendingDeposits)); ?> <?php echo e($general->cur_text); ?>

                                        <?php echo app('translator')->get('deposit request is pending. Please wait for admin approval. See'); ?> <a href="<?php echo e(route('user.deposit.history')); ?>"
                                            class="link-color"><?php echo app('translator')->get('deposit history'); ?></a></i></small>
                            </p>
                        </div>
                    <?php endif; ?>

                    <?php if(!$user->ts): ?>
                        <div class="alert border border--warning" role="alert">
                            <div class="alert__icon d-flex align-items-center text--warning"><i
                                    class="fas fa-user-lock"></i></div>
                            <p class="alert__message">
                                <span class="fw-bold"><?php echo app('translator')->get('2FA Authentication'); ?></span><br>
                                <small><i><?php echo app('translator')->get('To keep safe your account, Please enable'); ?> <a href="<?php echo e(route('user.twofactor')); ?>"
                                            class="link-color"><?php echo app('translator')->get('2FA'); ?></a> <?php echo app('translator')->get('security'); ?>.</i>
                                    <?php echo app('translator')->get('It will make secure your account and balance.'); ?></small>
                            </p>
                        </div>
                    <?php endif; ?>

                    <?php if($isHoliday): ?>
                        <div class="alert border border--info" role="alert">
                            <div class="alert__icon d-flex align-items-center text--info"><i class="fas fa-toggle-off"></i>
                            </div>
                            <p class="alert__message">
                                <span class="fw-bold"><?php echo app('translator')->get('Holiday'); ?></span><br>
                                <small><i><?php echo app('translator')->get('Today is holiday on this system. You\'ll not get any interest today from this system. Also you\'re unable to make withdrawal request today.'); ?> <br> <?php echo app('translator')->get('The next working day is coming after'); ?> <span id="counter" class="fw-bold text--base fs--15px"></span></i></small>
                            </p>
                        </div>
                    <?php endif; ?>

                    <?php if($user->kv == 0): ?>
                        <div class="alert border border--info" role="alert">
                            <div class="alert__icon d-flex align-items-center text--info"><i
                                    class="fas fa-file-signature"></i>
                            </div>
                            <p class="alert__message">
                                <span class="fw-bold"><?php echo app('translator')->get('KYC Verification Required'); ?></span><br>
                                <small><i><?php echo app('translator')->get('Please submit the required KYC information to verify yourself. Otherwise, you couldn\'t make any withdrawal requests to the system.'); ?> <a href="<?php echo e(route('user.kyc.form')); ?>"
                                            class="link-color"><?php echo app('translator')->get('Click here'); ?></a> <?php echo app('translator')->get('to submit KYC information'); ?>.</i></small>
                            </p>
                        </div>
                    <?php elseif($user->kv == 2): ?>
                        <div class="alert border border--warning" role="alert">
                            <div class="alert__icon d-flex align-items-center text--warning"><i
                                    class="fas fa-user-check"></i></div>
                            <p class="alert__message">
                                <span class="fw-bold"><?php echo app('translator')->get('KYC Verification Pending'); ?></span><br>
                                <small><i><?php echo app('translator')->get('Your submitted KYC information is pending for admin approval. Please wait till that.'); ?> <a href="<?php echo e(route('user.kyc.data')); ?>"
                                            class="link-color"><?php echo app('translator')->get('Click here'); ?></a> <?php echo app('translator')->get('to see your submitted information'); ?></i></small>
                            </p>
                        </div>
                    <?php endif; ?>
                </div>

            </div>
            <div class="row">

                <div class="col-lg-12">
                    <div class="dashboard-main">
                        <div class="row mt-30 mb-5">

                            <div class="col-lg-3 col-md-6 mb-30">
                                <div class="stat-item">
                                    <i class="las la-piggy-bank base--color"></i>
                                    <h6 class="caption text-shadow"><?php echo app('translator')->get('Deposit Wallet'); ?></h6>
                                    <span
                                        class="total__amount"><?php echo e($general->cur_sym); ?><?php echo e(showAmount($user->deposit_wallet)); ?></span>

                                    <div class="d-flex justify-content-center mt-3">
                                        <a href="<?php echo e(route('user.transactions')); ?>?wallet_type=deposit_wallet"
                                            class="btn btn-primary btn-small d-block text-center style--two"><?php echo app('translator')->get('View report'); ?></a>
                                    </div>

                                </div>
                            </div>

                            <div class="col-lg-3 col-md-6 mb-30">
                                <div class="stat-item">
                                    <i class="las la-piggy-bank base--color"></i>
                                    <h6 class="caption text-shadow"><?php echo app('translator')->get('Interest Wallet'); ?></h6>
                                    <span
                                        class="total__amount"><?php echo e($general->cur_sym); ?><?php echo e(showAmount($user->interest_wallet)); ?></span>
                                    <div class="d-flex justify-content-center mt-3">
                                        <a href="<?php echo e(route('user.transactions')); ?>?wallet_type=interest_wallet"
                                            class="btn btn-primary btn-small d-block text-center style--two"><?php echo app('translator')->get('View report'); ?></a>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-3 col-md-6 mb-30">
                                <div class="stat-item">
                                    <i class="las la-credit-card base--color"></i>
                                    <h6 class="caption text-shadow"><?php echo app('translator')->get('Total Invest'); ?></h6>
                                    <span
                                        class="total__amount"><?php echo e($general->cur_sym); ?><?php echo e(showAmount($totalInvest)); ?></span>
                                    <div class="d-flex justify-content-center mt-3">
                                        <a href="<?php echo e(route('user.transactions')); ?>?remark=invest"
                                            class="btn btn-primary btn-small d-block text-center style--two"><?php echo app('translator')->get('View report'); ?></a>
                                    </div>
                                </div><!-- stat-item end -->
                            </div>

                            <div class="col-lg-3 col-md-6 mb-30">
                                <div class="stat-item">
                                    <i class="las la-ticket-alt base--color"></i>
                                    <h6 class="caption text-shadow"><?php echo app('translator')->get('Total Ticket'); ?></h6>
                                    <span class="total__amount"><?php echo e($totalTicket); ?> </span>
                                    <div class="d-flex justify-content-center mt-3">
                                        <a href="<?php echo e(route('ticket.index')); ?>"
                                            class="btn btn-primary btn-small d-block text-center style--two"><?php echo app('translator')->get('View Report'); ?></a>
                                    </div>
                                </div><!-- stat-item end -->
                            </div>

                            <div class="col-lg-6">
                                <div class="stat-wrapper deposit">
                                    <div class="stat__header">
                                        <div class="left">
                                            <div class="icon"><i class="las la-chart-area"></i></div>
                                            <h3 class="caption"><?php echo app('translator')->get('Deposit'); ?></h3>
                                        </div>
                                        <div class="right"><i class="flaticon-next"></i></div>
                                    </div>
                                    <div class="item-wrapper">
                                        <div class="stat-item-two box-shadow-two">
                                            <h5 class="caption text-shadow"><?php echo app('translator')->get('Total Deposit'); ?></h5>
                                            <span
                                                class="total__amount base--color"><?php echo e($general->cur_sym); ?><?php echo e(showAmount($totalDeposit)); ?></span>
                                        </div><!-- stat-item-two end -->
                                        <div class="stat-item-two box-shadow-two">
                                            <h5 class="caption text-shadow"><?php echo app('translator')->get('Last Deposit'); ?></h5>
                                            <span
                                                class="total__amount base--color"><?php echo e($general->cur_sym); ?><?php echo e(showAmount(@$lastDeposit->amount ?? 0)); ?></span>
                                        </div><!-- stat-item-two end -->

                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-6 mt-lg-0 mt-5">
                                <div class="stat-wrapper withdraw">
                                    <div class="stat__header">
                                        <div class="left">
                                            <div class="icon"><i class="las la-credit-card"></i></div>
                                            <h3 class="caption"><?php echo app('translator')->get('Withdraw'); ?></h3>
                                        </div>
                                        <div class="right"><i class="flaticon-next"></i></div>
                                    </div>
                                    <div class="item-wrapper">
                                        <div class="stat-item-two box-shadow-two">
                                            <h5 class="caption text-shadow"><?php echo app('translator')->get('Total Withdraw'); ?></h5>
                                            <span
                                                class="total__amount base--color"><?php echo e($general->cur_sym); ?><?php echo e(showAmount($totalWithdraw)); ?></span>
                                        </div><!-- stat-item-two end -->
                                        <div class="stat-item-two box-shadow-two">
                                            <h5 class="caption text-shadow"><?php echo app('translator')->get('Last Withdraw'); ?></h5>
                                            <span
                                                class="total__amount base--color"><?php echo e($general->cur_sym); ?><?php echo e(showAmount(@$lastWithdraw->amount ?? 0)); ?></span>
                                        </div><!-- stat-item-two end -->

                                    </div><!-- item-wrapper end -->
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div><!-- row end -->
        </div>
    </section>

    <?php $__env->stopSection(); ?>
    <?php $__env->startPush('style'); ?>
        <style>
            #copyBoard {
                cursor: pointer;
            }
        </style>
    <?php $__env->stopPush(); ?>
    <?php $__env->startPush('script'); ?>
        <script>
            'use strict';
            (function($) {
                <?php if($isHoliday): ?>
                    function createCountDown(elementId, sec) {
                        var tms = sec;
                        var x = setInterval(function() {
                            var distance = tms * 1000;
                            var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                            var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                            var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                            var seconds = Math.floor((distance % (1000 * 60)) / 1000);
                            var days = `<span class="text--base">${days}d</span>`;
                            var hours = `<span class="text--base">${hours}h</span>`;
                            var minutes = `<span class="text--base">${minutes}m</span>`;
                            var seconds = `<span class="text--base">${seconds}s</span>`;
                            document.getElementById(elementId).innerHTML = days + ' ' + hours + " " + minutes +
                                " " + seconds;
                            if (distance < 0) {
                                clearInterval(x);
                                document.getElementById(elementId).innerHTML = "COMPLETE";
                            }
                            tms--;
                        }, 1000);
                    }

                    createCountDown('counter', <?php echo e(\Carbon\Carbon::parse($nextWorkingDay)->diffInSeconds()); ?>);
                <?php endif; ?>
            })(jQuery);
        </script>
    <?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/top1/trustpay.56-0.top/core/resources/views/templates/neo_dark/user/dashboard.blade.php ENDPATH**/ ?>