<?php $__env->startSection('content'); ?>
<script>
    "use strict"
    function createCountDown(elementId, sec) {
        var tms = sec;
        var x = setInterval(function () {
            var distance = tms * 1000;
            var days = Math.floor(distance / (1000 * 60 * 60 * 24));
            var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((distance % (1000 * 60)) / 1000);
            var days = `<span>${days}d</span>`;
            var hours = `<span>${hours}h</span>`;
            var minutes = `<span>${minutes}m</span>`;
            var seconds = `<span>${seconds}s</span>`;
            document.getElementById(elementId).innerHTML = days +' '+ hours + " " + minutes + " " + seconds;
            if (distance < 0) {
                clearInterval(x);
                document.getElementById(elementId).innerHTML = "COMPLETE";
            }
            tms--;
        }, 1000);
    }
    </script>
<div class="cmn-section">
    <div class="container">
        <div class="row mb-4 mb-sm-5 justify-content-center">
            <div class="col-lg-6">
                <div class="text-end">
                    <a href="<?php echo e(route('user.withdraw.history')); ?>" class="btn btn--base"><?php echo app('translator')->get('Withdraw History'); ?></a>
                </div>
            </div>
        </div>
        <div class="row justify-content-center">
            <div class="col-lg-6">
                <div class="card custom--card <?php if($isHoliday && !$general->holiday_withdraw): ?> countdown-card <?php endif; ?>">
                    <div class="card-body">
                        <?php if($isHoliday && !$general->holiday_withdraw): ?>
                        <div class="text-center">
                            <h4 class="mb-3"><?php echo app('translator')->get('Withdrawal request is disable for today. Please wait for next working day.'); ?></h4>
                            <h2 class="text--base mb-3"><?php echo app('translator')->get('Next Working Day'); ?></h2>
                            <div id="counter" class="countdown-wrapper"></div>
                            <script>createCountDown('counter', <?php echo e(\Carbon\Carbon::parse($nextWorkingDay)->diffInSeconds()); ?>);</script>
                        </div>
                        <?php else: ?>
                        <form action="<?php echo e(route('user.withdraw.money')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <label class="form-label"><?php echo app('translator')->get('Method'); ?></label>
                                <select class="form-control form--control" name="method_code" required>
                                    <option value=""><?php echo app('translator')->get('Select Gateway'); ?></option>
                                    <?php $__currentLoopData = $withdrawMethod; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($data->id); ?>" data-resource="<?php echo e($data); ?>">  <?php echo e(__($data->name)); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label class="form-label"><?php echo app('translator')->get('Amount'); ?></label>
                                <div class="input-group">
                                    <input type="number" step="any" name="amount" value="<?php echo e(old('amount')); ?>" class="form-control form--control" required>
                                    <span class="input-group-text bg--base"><?php echo e($general->cur_text); ?></span>
                                </div>
                            </div>
                            <div class="mt-3 preview-details d-none">
                                <ul class="list-group text-center">
                                    <li class="list-group-item d-flex justify-content-between">
                                        <span><?php echo app('translator')->get('Limit'); ?></span>
                                        <span><span class="min fw-bold">0</span> <?php echo e(__($general->cur_text)); ?> - <span class="max fw-bold">0</span> <?php echo e(__($general->cur_text)); ?></span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between">
                                        <span><?php echo app('translator')->get('Charge'); ?></span>
                                        <span><span class="charge fw-bold">0</span> <?php echo e(__($general->cur_text)); ?></span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between">
                                        <span><?php echo app('translator')->get('Receivable'); ?></span> <span><span class="receivable fw-bold"> 0</span> <?php echo e(__($general->cur_text)); ?> </span>
                                    </li>
                                    <li class="list-group-item d-none justify-content-between rate-element">

                                    </li>
                                    <li class="list-group-item d-none justify-content-between in-site-cur">
                                        <span><?php echo app('translator')->get('In'); ?> <span class="base-currency"></span></span>
                                        <strong class="final_amo">0</strong>
                                    </li>
                                </ul>
                            </div>
                            <button type="submit" class="btn--base w-100 mt-3"><?php echo app('translator')->get('Submit'); ?></button>
                        </form>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    (function ($) {
            "use strict";
            $('select[name=method_code]').change(function(){
                if(!$('select[name=method_code]').val()){
                    $('.preview-details').addClass('d-none');
                    return false;
                }
                var resource = $('select[name=method_code] option:selected').data('resource');
                var fixed_charge = parseFloat(resource.fixed_charge);
                var percent_charge = parseFloat(resource.percent_charge);
                var rate = parseFloat(resource.rate)
                var toFixedDigit = 2;
                $('.min').text(parseFloat(resource.min_limit).toFixed(2));
                $('.max').text(parseFloat(resource.max_limit).toFixed(2));
                var amount = parseFloat($('input[name=amount]').val());
                if (!amount) {
                    amount = 0;
                }
                if(amount <= 0){
                    $('.preview-details').addClass('d-none');
                    return false;
                }
                $('.preview-details').removeClass('d-none');

                var charge = parseFloat(fixed_charge + (amount * percent_charge / 100)).toFixed(2);
                $('.charge').text(charge);
                if (resource.currency != '<?php echo e($general->cur_text); ?>') {
                    var rateElement = `<span><?php echo app('translator')->get('Conversion Rate'); ?></span> <span class="fw-bold">1 <?php echo e(__($general->cur_text)); ?> = <span class="rate">${rate}</span>  <span class="base-currency">${resource.currency}</span></span>`;
                    $('.rate-element').html(rateElement);
                    $('.rate-element').removeClass('d-none');
                    $('.in-site-cur').removeClass('d-none');
                    $('.rate-element').addClass('d-flex');
                    $('.in-site-cur').addClass('d-flex');
                }else{
                    $('.rate-element').html('')
                    $('.rate-element').addClass('d-none');
                    $('.in-site-cur').addClass('d-none');
                    $('.rate-element').removeClass('d-flex');
                    $('.in-site-cur').removeClass('d-flex');
                }
                var receivable = parseFloat((parseFloat(amount) - parseFloat(charge))).toFixed(2);
                $('.receivable').text(receivable);
                var final_amo = parseFloat(parseFloat(receivable)*rate).toFixed(toFixedDigit);
                $('.final_amo').text(final_amo);
                $('.base-currency').text(resource.currency);
                $('.method_currency').text(resource.currency);
                $('input[name=amount]').on('input');
            });
            $('input[name=amount]').on('input',function(){
                var data = $('select[name=method_code]').change();
                $('.amount').text(parseFloat($(this).val()).toFixed(2));
            });
        })(jQuery);
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/top1/trustpay.56-0.top/core/resources/views/templates/bit_gold/user/withdraw/methods.blade.php ENDPATH**/ ?>