<?php $__env->startSection('content'); ?>
    <?php
    $loginContent = getContent('login.content', true);
    ?>

    <div class="signin-wrapper">
        <div class="outset-circle"></div>
        <div class="container">
            <div class="row justify-content-lg-between align-items-center">
                <div class="col-xl-5 col-lg-6">
                    <div class="signin-thumb">
                        <img src="<?php echo e(getImage('assets/images/frontend/login/' . @$loginContent->data_values->image)); ?>" alt="image">
                    </div>
                </div>
                <div class="col-xl-5 col-lg-6">
                    <div class="signin-form-area">
                        <h3 class="title text-capitalize text-shadow mb-30"><?php echo e(__($pageTitle)); ?></h3>
                        <button class="btn btn-success btn-small w-100 mb-3 btn-primary metamaskLogin"><img src="<?php echo e(asset($activeTemplateTrue.'images/metamask.png')); ?>" alt="<?php echo app('translator')->get('image'); ?>" class="metamask-image"> <?php echo app('translator')->get('Login with Metamask'); ?></button>
                        <form class="signin-form verify-gcaptcha" action="<?php echo e(route('user.login')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <label class="form-label"><?php echo app('translator')->get('Username'); ?></label>
                                <input  type="text" name="username" id="signin_name" placeholder="<?php echo app('translator')->get('Username or Email'); ?>" value="<?php echo e(old('username')); ?>" required>
                            </div>

                            <div class="form-group">
                                <label class="form-label"><?php echo app('translator')->get('Password'); ?></label>
                                <input type="password" name="password" id="signin_pass" placeholder="<?php echo app('translator')->get('Password'); ?>" required autocomplete="current-password" required>
                            </div>

                            <?php if (isset($component)) { $__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243 = $component; } ?>
<?php $component = App\View\Components\Captcha::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Captcha::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243)): ?>
<?php $component = $__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243; ?>
<?php unset($__componentOriginalc0af13564821b3ac3d38dfa77d6cac9157db8243); ?>
<?php endif; ?>

                            <div class="custom--checkbox mb-3">
                                <input class="w-auto h-auto" type="checkbox" name="remember" id="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                <label class="mb-0" for="remember">
                                    <?php echo app('translator')->get('Remember Me'); ?>
                                </label>
                            </div>
                            <div class="form-group">
                                <button type="submit" class="btn btn-success btn-small w-100 btn-primary"><?php echo app('translator')->get('Sign In'); ?></button>
                            </div>
                            <p><?php echo e(trans('Forgot Your Password?')); ?>

                                <a href="<?php echo e(route('user.password.request')); ?>" class="label-text base--color"><?php echo app('translator')->get('Reset Now'); ?></a>
                            </p>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/global/js/web3.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        var account = null;
        var signature = null;
        var message = 'Sign in koro';
        var token = null;
        $('.metamaskLogin').on('click', async () => {
            // detect wallet
            if (!window.ethereum) {
                notify('error', 'MetaMask not detected. Please install MetaMask first.');
                return;
            }

            // get wallet address
            await window.ethereum.request({
                method: 'eth_requestAccounts'
            });
            window.web3 = new Web3(window.ethereum);
            accounts = await web3.eth.getAccounts();
            account = accounts[0];

            // get unique message
            let response = await fetch(`<?php echo e(route('user.login.metamask')); ?>`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    'account': account,
                    '_token': '<?php echo e(csrf_token()); ?>'
                })
            });
            message = (await response.json()).message;
            setTimeout(async () => {
                // get signature
                signature = await web3.eth.personal.sign(message, account);

                // verify signature
                response = await fetch(`<?php echo e(route('user.login.metamask.verify')); ?>`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        'signature': signature,
                        '_token': '<?php echo e(csrf_token()); ?>'
                    })
                });
                response = await response.json();

                notify(response.type, response.message);

                // handle login
                if (response.type == 'success') {
                    setTimeout(() => {
                        window.location.href = response.redirect_url;
                    }, 2000);
                }
            }, 1500);

        })
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bmsskabi/public_html/core/resources/views/templates/neo_dark/user/auth/login.blade.php ENDPATH**/ ?>