
<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Icon'); ?></th>
                                    <th><?php echo app('translator')->get('Level'); ?></th>
                                    <th><?php echo app('translator')->get('Name'); ?></th>
                                    <th><?php echo app('translator')->get('Minimum Invest'); ?></th>
                                    <th><?php echo app('translator')->get('Bonus'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $userRankings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $userRanking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><img src="<?php echo e(getImage(getFilePath('userRanking') . '/' . $userRanking->icon, getFileSize('userRanking'))); ?>" class="ranking-image" alt=""></td>
                                        <td><?php echo e(__($userRanking->level)); ?></td>
                                        <td><?php echo e(__($userRanking->name)); ?></td>
                                        <td><?php echo e($general->cur_sym); ?><?php echo e(showAmount($userRanking->minimum_invest)); ?></td>
                                        <td><?php echo e($general->cur_sym); ?><?php echo e(showAmount($userRanking->bonus)); ?></td>
                                        <td>
                                            <?php
                                                echo $userRanking->statusBadge;
                                            ?>
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-outline--primary editBtn me-1" data-icon="<?php echo e(getImage(getFilePath('userRanking') . '/' . $userRanking->icon, getFileSize('userRanking'))); ?>" data-ranking="<?php echo e($userRanking); ?>"
                                                data-action="<?php echo e(route('admin.plan.update', $userRanking->id)); ?>"><i class="las la-pen"></i><?php echo app('translator')->get('Edit'); ?></button>
                                            <?php if($userRanking->status): ?>
                                                <button class="btn btn-sm btn-outline--danger confirmationBtn" data-question="<?php echo app('translator')->get('Are you sure to disable this ranking?'); ?>" data-action="<?php echo e(route('admin.ranking.status', $userRanking->id)); ?>"><i class="las la-eye-slash"></i><?php echo app('translator')->get('Disable'); ?></button>
                                            <?php else: ?>
                                                <button class="btn btn-sm btn-outline--success confirmationBtn" data-question="<?php echo app('translator')->get('Are you sure to enable this ranking?'); ?>" data-action="<?php echo e(route('admin.ranking.status', $userRanking->id)); ?>"><i class="las la-eye"></i><?php echo app('translator')->get('Enable'); ?></button>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
            </div><!-- card end -->
        </div>
    </div>

    <div class="modal fade" id="rankingModal">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Add New User Ranking'); ?></h5>
                    <button type="button" class="close" data-bs-dismiss="modal">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="<?php echo e(route('admin.ranking.store')); ?>" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-xl-4 col-lg-5">
                                <div class="form-group">
                                    <label class="icon"><?php echo app('translator')->get('Icon'); ?></label>
                                    <div class="image-upload">
                                        <div class="thumb">
                                            <div class="avatar-preview">
                                                <div class="profilePicPreview">
                                                    <button type="button" class="remove-image"><i class="fa fa-times"></i></button>
                                                </div>
                                            </div>
                                            <div class="avatar-edit">
                                                <input type="file" class="profilePicUpload d-none" name="icon" id="profilePicUpload1" accept=".png, .jpg, .jpeg" required>
                                                <label for="profilePicUpload1" class="bg--success mt-3"><?php echo app('translator')->get('Upload Image'); ?></label>
                                                <small class="mt-2"><?php echo app('translator')->get('Supported files'); ?>: <b><?php echo app('translator')->get('png'); ?>, <?php echo app('translator')->get('jpeg'); ?>, <?php echo app('translator')->get('jpg'); ?>.</b> <?php echo app('translator')->get('Image will be resized into '); ?> <?php echo e(getFileSize('userRanking')); ?> <?php echo app('translator')->get('px'); ?></small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-8 col-lg-7">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label><?php echo app('translator')->get('Level'); ?></label>
                                            <input type="number" class="form-control" name="level" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label><?php echo app('translator')->get('Name'); ?></label>
                                            <input type="text" class="form-control" name="name" required>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Minimum Invest'); ?></label>
                                    <div class="input-group">
                                        <input type="number" step="any" name="minimum_invest" min="0" class="form-control" required>
                                        <span class="input-group-text"><?php echo e($general->cur_text); ?></span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Team Minimum Invest'); ?></label>
                                    <div class="input-group">
                                        <input type="number" step="any" name="team_minimum_invest" min="0" class="form-control" required>
                                        <span class="input-group-text"><?php echo e($general->cur_text); ?></span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Minimum Direct Referral'); ?></label>
                                        <input type="number" name="min_referral" min="0" class="form-control" required>
                                </div>
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Bonus'); ?></label>
                                    <div class="input-group">
                                        <input type="number" step="any" name="bonus" min="0" class="form-control" required>
                                        <span class="input-group-text"><?php echo e($general->cur_text); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php if (isset($component)) { $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b = $component; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\ConfirmationModal::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b)): ?>
<?php $component = $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b; ?>
<?php unset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <button class="btn btn-outline--primary btn-sm addBtn" data-icon="<?php echo e(getImage(null, getFileSize('userRanking'))); ?>"><i class="las la-plus"></i> <?php echo app('translator')->get('Add New'); ?></button>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .image-upload .thumb .profilePicPreview {
            height: 230px;
        }
        .ranking-image{
            width: 60px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict"
            let modal = $('#rankingModal');
            let action = `<?php echo e(route('admin.ranking.store')); ?>`;

            $('.addBtn').on('click', function() {
                modal.find('form').attr('action', action);
                modal.modal('show');
                modal.find('form')[0].reset();
                modal.find('.profilePicPreview').css('backgroundImage', `url(${$(this).data('icon')})`);
            });

            $('.editBtn').on('click', function() {
                let ranking = $(this).data('ranking');
                modal.find('[name=level]').val(ranking.level);
                modal.find('[name=name]').val(ranking.name);
                modal.find('[name=minimum_invest]').val(parseFloat(ranking.minimum_invest).toFixed(2));
                modal.find('[name=team_minimum_invest]').val(parseFloat(ranking.min_referral_invest).toFixed(2));
                modal.find('[name=min_referral]').val(ranking.min_referral);
                modal.find('[name=bonus]').val(parseFloat(ranking.bonus).toFixed(2));
                modal.find('[name=description]').val(ranking.description);
                modal.find('.profilePicPreview').css('backgroundImage', `url(${$(this).data('icon')})`);
                modal.find('.icon').removeClass('required');
                modal.find('[name=icon]').removeAttr('required');

                modal.find('form').attr('action', `${action}/${ranking.id}`);
                modal.modal('show');
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yesuntec/y77.ye-suntechdemo.pw/core/resources/views/admin/user_ranking/list.blade.php ENDPATH**/ ?>