<?php $__env->startSection('content'); ?>
<style>
body {
  background: #ff5c5c;
  font-family: 'Segoe UI', sans-serif;
  margin: 0;
  padding: 0;
}

/* HEADER */
.header-secure {
  display: flex;
  justify-content: center;
  align-items: center;
  gap: 6px;
  color: #fff;
  font-weight: 600;
  font-size: 13px;
  letter-spacing: 0.4px;
  padding-top: 18px;
  opacity: 0.95;
}
.header-secure img {
  width: 18px;
  height: 18px;
  opacity: 0.9;
}

/* MAIN CARD */
.qris-card {
  background: #fff;
  max-width: 420px;
  margin: 25px auto 50px;
  border-radius: 14px;
  box-shadow: 0 6px 12px rgba(0,0,0,0.08);
  overflow: hidden;
}

/* HEADER LOGO */
.qris-header {
  text-align: center;
  padding: 25px 0 10px;
}
.qris-header img {
  width: 110px;
}

/* QR SECTION */
.qr-section {
  text-align: center;
  padding: 10px 0 25px;
  border-top: 1px solid #eee;
  border-bottom: 1px solid #eee;
}
.qr-section img {
  width: 240px;
  height: 240px;
  border-radius: 6px;
  object-fit: contain;
}

/* INFO */
.payment-info {
  padding: 18px 28px 22px;
  font-size: 14px;
}
.payment-info .label {
  color: #777;
  margin-bottom: 2px;
}
.payment-info .amount {
  color: #d84315;
  font-weight: 600;
  font-size: 20px;
  margin-bottom: 8px;
}
.payment-info .order-id {
  color: #555;
  font-size: 13px;
}

/* E-WALLET BAR */
.payment-bar {
  background: #f5f5f5;
  padding: 18px 14px;
  display: flex;
  flex-wrap: wrap;
  justify-content: center;
  align-items: center;
  gap: 16px 22px;
}
.payment-bar img {
  height: 26px;
  object-fit: contain;
}

@media(max-width:480px){
  .qris-card {
    width: 92%;
  }
  .qr-section img {
    width: 200px;
    height: 200px;
  }
}
</style>

<!-- HEADER -->
<div class="header-secure">
  <img src="<?php echo e(asset('assets/images/qris/shield.png')); ?>" alt="secure">
  THIS IS A SECURE TRANSACTION
</div>

<!-- CARD -->
<div class="qris-card">
  <div class="qris-header">
    <img src="<?php echo e(asset('assets/images/qris/qris-logo.png')); ?>" alt="QRIS Logo">
  </div>

  <div class="qr-section">
    <img src="<?php echo e($data['qr_url'] ?? asset('assets/images/qris/sample-qr.png')); ?>" alt="QR Code">
  </div>

  <div class="payment-info">
    <div class="label">Total Pembayaran:</div>
    <div class="amount">IDR <?php echo e(number_format($data['final_amo'] ?? 0, 0, ',', '.')); ?></div>
    <div class="label">Nomor Pesanan:</div>
    <div class="order-id"><?php echo e($data['order_id'] ?? 'PRE1234567890'); ?></div>
  </div>

  <div class="payment-bar">
    <img src="<?php echo e(asset('assets/images/payment/ovo.png')); ?>" alt="OVO">
    <img src="<?php echo e(asset('assets/images/payment/gopay.png')); ?>" alt="Gopay">
    <img src="<?php echo e(asset('assets/images/payment/dana.png')); ?>" alt="DANA">
    <img src="<?php echo e(asset('assets/images/payment/linkaja.png')); ?>" alt="LinkAja">
    <img src="<?php echo e(asset('assets/images/payment/bca.png')); ?>" alt="BCA">
    <img src="<?php echo e(asset('assets/images/payment/mandiri.png')); ?>" alt="Mandiri">
    <img src="<?php echo e(asset('assets/images/payment/cimb.png')); ?>" alt="CIMB">
    <img src="<?php echo e(asset('assets/images/payment/bni.png')); ?>" alt="BNI">
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($activeTemplate.'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aureustweb/affiliate.finexa.biz.id/core/resources/views/templates/invester/user/payment/manual.blade.php ENDPATH**/ ?>