@extends($activeTemplate.'layouts.master')

@section('content')

<style>
    body {
        background: #111;
        font-family: 'Poppins', sans-serif;
        color: #fff;
        margin: 0;
        padding-bottom: 80px;
    }

    .navbar {
        background: gold;
        color: #000;
        text-align: center;
        padding: 14px 0;
        font-weight: 700;
        font-size: 16px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.3);
        position: sticky;
        top: 0;
        z-index: 10;
    } 
    .navbar {
  border: 2px solid #666;        /* bikin garis */
  box-sizing: border-box;        /* biar garis ikut ukuran tombol */
}

    .proof-wrapper {
        padding: 14px;
        padding-bottom: 100px;
    }

    .proof-card {
        background: #fff;
        color: #000;
        border-radius: 12px;
        padding: 8px 10px;
        margin-bottom: 10px;
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.22);
    }

    .info-line {
        font-weight: 600;
        font-size: 14px;
        display: flex;
        align-items: center;
        gap: 6px;
        color: #000;
        margin-bottom: 2px;
    }

    .user-id {
        font-size: 13px;
        color: #333;
        margin-left: 22px;
        margin-bottom: 2px;
    }

    .time {
        font-size: 11px;
        color: #777;
        margin-left: 22px;
        margin-bottom: 4px;
    }

    .proof-thumb {
        width: auto;
        max-width: 170px;
        max-height: 85px;
        border-radius: 10px;
        border: 2px solid #eee;
        object-fit: contain;
        display: block;
        margin-left: 22px;
        margin-bottom: 4px;
        cursor: pointer;
        transition: 0.2s ease;
    }

    .proof-thumb:hover {
        transform: scale(1.02);
    }

    .caption {
        background: #f4f6fa;
        border-radius: 8px;
        padding: 6px 10px;
        font-size: 13px;
        font-weight: 600;
        color: #222;
        margin-left: 22px;
        margin-right: 10px;
    }

    /* Tombol Unggah (Tabbar) */
    .tabbar-upload {
        position: fixed;
        bottom: 70px;
        left: 50%;
        transform: translateX(-50%);
        width: 50%;
        background: gold;
        border: none;
        color: #111;
        padding: 9px 0;
        font-weight: 700;
        font-size: 16px;
        text-align: center;
        box-shadow: 0 -3px 10px rgba(0, 0, 0, 0.3);
        z-index: 999;
        cursor: pointer;
        border-radius: 12px; 
} 
.tabbar-upload {
  border: 2px solid #444;        /* bikin garis */
  box-sizing: border-box;        /* biar garis ikut ukuran tombol */
}
    }

    .tabbar-upload:hover {
        background: linear-gradient(90deg, #B29222, #F5D600);
        transform: translate(-50%, -2px);
    }

    /* Popup Tengah Layar */
    .popup-overlay {
        display: none;
        position: fixed;
        inset: 0;
        background: rgba(0, 0, 0, 0.6);
        justify-content: center;
        align-items: center;
        z-index: 1000;
    }

    .popup {
        background: linear-gradient(180deg, #FFD700, #C9A227);
        width: 90%;
        max-width: 400px;
        border-radius: 16px;
        padding: 20px;
        animation: fadeIn 0.35s ease forwards;
        position: relative;
        color: #000;
        box-shadow: 0 4px 20px rgba(0,0,0,0.3);
    }

    @keyframes fadeIn {
        from { transform: scale(0.9); opacity: 0; }
        to { transform: scale(1); opacity: 1; }
    }

    .popup h4 {
        text-align: center;
        font-size: 16px;
        margin-bottom: 15px;
        font-weight: 700;
    }

    /* Form styling */
    .popup form {
        display: flex;
        flex-direction: column;
        gap: 12px;
    }

    .input-box {
        border: 2px solid rgba(0,0,0,0.3);
        border-radius: 10px;
        padding: 10px;
        background: #fff;
    }

    .input-box textarea {
        width: 100%;
        border: none;
        outline: none;
        font-size: 14px;
        resize: none;
        color: #000;
        font-family: 'Poppins', sans-serif;
    }

    .input-box input[type=file] {
        width: 100%;
        border: none;
        outline: none;
        font-size: 14px;
        background: transparent;
        color: #000;
    }

    .popup .btn-submit {
        align-self: flex-end;
        background: #000;
        color: #FFD700;
        border: none;
        border-radius: 10px;
        padding: 10px 18px;
        font-weight: 700;
        cursor: pointer;
        transition: 0.2s;
    }

    .popup .btn-submit:hover {
        background: #222;
    }

    .popup .close-popup {
        position: absolute;
        top: 8px;
        right: 12px;
        background: transparent;
        border: none;
        color: #000;
        font-size: 26px;
        cursor: pointer;
        font-weight: 700;
    }

    .img-viewer {
        display: none;
        position: fixed;
        inset: 0;
        background: rgba(0, 0, 0, 0.85);
        justify-content: center;
        align-items: center;
        z-index: 2000;
    }

    .img-viewer img {
        max-width: 95%;
        max-height: 90%;
        border-radius: 10px;
        box-shadow: 0 0 20px rgba(255, 255, 255, 0.3);
    }
</style>

<div class="navbar">💰 Informasi Penarikan</div>

<div class="proof-wrapper">
    @foreach ($proofs as $proof)
        @php
            $username = $proof->user->username ?? '0000000000';
            $digits = preg_replace('/\D+/', '', $username);
            if (strlen($digits) >= 9) {
                $formatted = '62 ' . substr($digits, 0, 5) . '*****' . substr($digits, -4);
            } else {
                $formatted = '62 ' . $digits;
            }
        @endphp

        <div class="proof-card">
            <div class="info-line">📱 {{ $formatted }}</div>
            <div class="user-id">🆔 ID: {{ $proof->user->id }}</div>
            <div class="time">🕒 {{ $proof->created_at->format('d M Y H:i') }}</div>

            @if($proof->image)
                <img src="{{ url('core/img/' . $proof->image) }}"   
                     alt="Bukti Withdraw"   
                     class="proof-thumb"  
                     onclick="showImage('{{ url('core/img/' . $proof->image) }}')">
            @endif

            @if($proof->caption)
                <div class="caption">{{ $proof->caption }}</div>
            @endif
        </div>
    @endforeach
</div>

<!-- Tombol Unggah -->
<div class="tabbar-upload" id="openPopup">⬆️ Unggah Hasil Penarikan</div>

<!-- Popup Tengah -->
<div class="popup-overlay" id="popupOverlay">
    <div class="popup">
        <button class="close-popup" id="closePopup">&times;</button>
        <h4>Masukkan Komentar dan Unggah Hasil Penarikan</h4>
        <form action="{{ route('user.withdraw.proofs.upload') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="input-box">
                <textarea name="caption" rows="3" placeholder="Tulis Komentar kamu..." required></textarea>
            </div>
            <div class="input-box">
                <input type="file" name="image" accept="image/*" required>
            </div>
            <button type="submit" class="btn-submit">Kirim ➤</button>
        </form>
    </div>
</div>

<!-- Image Viewer -->
<div class="img-viewer" id="imgViewer" onclick="closeImage()">
    <img id="viewerImg" src="">
</div>
@if(session('success'))
    <div id="notifSuccess" style="
        position: fixed;
        top: 20px;
        left: 50%;
        transform: translateX(-50%);
        background: #28a745;
        color: #fff;
        font-weight: 600;
        border-radius: 12px;
        padding: 12px 18px;
        text-align: center;
        z-index: 3000;
        box-shadow: 0 4px 15px rgba(0,0,0,0.3);
        animation: fadeInOut 3.5s ease forwards;
    ">
        {{ session('success') }}
    </div>

    <style>
        @keyframes fadeInOut {
            0% { opacity: 0; transform: translate(-50%, -20px); }
            15% { opacity: 1; transform: translate(-50%, 0); }
            85% { opacity: 1; transform: translate(-50%, 0); }
            100% { opacity: 0; transform: translate(-50%, -20px); }
        }
    </style>
@endif 
<script>
    const popupOverlay = document.getElementById('popupOverlay');
    const openPopup = document.getElementById('openPopup');
    const closePopup = document.getElementById('closePopup');

    openPopup.onclick = () => {
        popupOverlay.style.display = 'flex';
        openPopup.style.display = 'none';
    }

    closePopup.onclick = () => {
        popupOverlay.style.display = 'none';
        openPopup.style.display = 'block';
    }

    popupOverlay.onclick = (e) => {
        if (e.target === popupOverlay) {
            popupOverlay.style.display = 'none';
            openPopup.style.display = 'block';
        }
    }

    function showImage(src) {
        const viewer = document.getElementById('imgViewer');
        const viewerImg = document.getElementById('viewerImg');
        viewerImg.src = src;
        viewer.style.display = 'flex';
    }

    function closeImage() {
        document.getElementById('imgViewer').style.display = 'none';
    }
</script>

@endsection