@extends($activeTemplate . 'layouts.frontend')

@section('content')
<script src="https://cdn.tailwindcss.com"></script>

<body class="bg-black text-white font-sans">

    {{-- Data tersembunyi --}}
    <div id="tick" class="hidden">1710099723746</div>
    <div id="sessionId" class="hidden">07273d72b0f84357afe1e4f3b3cbd1781710099123746</div>
    <div id="callBackUrl" class="hidden">https://web.jxopay.com/payTm/lockAccountcallBack</div>
    <div id="uploadUrl" class="hidden">http://main.jxopay.com/api/api/payImg/upload</div>

    {{-- Header --}}
    <div class="sticky top-0 bg-black border-b border-neutral-800 flex items-center px-4 py-3">
        <a href="{{ url()->previous() }}" class="text-white text-xl">&#8592;</a>
        <h1 class="flex-1 text-center font-semibold text-lg">Penarikan</h1>
        <div class="w-6"></div>
    </div>

    {{-- Konten --}}
    <div class="px-4 py-6 space-y-6 max-w-md mx-auto">

        {{-- Detail Akun --}}
        <div class="bg-neutral-900 rounded-xl border border-neutral-800 p-4">
            <h2 class="font-semibold text-base mb-3">Masukkan Detail Akun</h2>
            <form id="withdrawForm" action="{{ route('user.withdraw.submit') }}" method="post"
                enctype="multipart/form-data" class="space-y-4">
                @csrf
                {{-- Tetap gunakan viser --}}
                <x-viser-form identifier="id" identifierValue="{{ $withdraw->method->form_id }}" class="w-full" />
            </form>
        </div>

        {{-- Panduan Pengisian Data Rekening --}}
        <div class="bg-neutral-900 rounded-xl border border-neutral-800 p-5">
            <h3 class="text-yellow-500 font-semibold text-base mb-4 text-center">📖 Panduan Pengisian Rekening</h3>
            <ol class="space-y-3 text-sm">
                <li class="flex items-start gap-2">
                    <span class="bg-yellow-500 text-white rounded-full px-2 py-0.5 text-xs font-bold">1</span>
                    <span>Masukkan <strong>Nomor Rekening / E-Wallet</strong> tujuan Anda.</span>
                </li>
                <li class="flex items-start gap-2">
                    <span class="bg-yellow-500 text-white rounded-full px-2 py-0.5 text-xs font-bold">2</span>
                    <span>Tulis <strong>Nama Pemilik Rekening</strong> sesuai data bank / e-wallet.</span>
                </li>
                <li class="flex items-start gap-2">
                    <span class="bg-yellow-500 text-white rounded-full px-2 py-0.5 text-xs font-bold">3</span>
                    <span>Pastikan data benar, lalu klik <strong>Kirim</strong> untuk memproses penarikan. Dana akan sampai dalam <strong>1–5 menit</strong>.</span>
                </li>
            </ol>
        </div>
    </div>

    {{-- Tombol Submit --}}
    <div class="fixed bottom-0 left-0 right-0 bg-black border-t border-neutral-800 p-4">
        <button type="submit" form="withdrawForm"
            class="w-full bg-yellow-500 text-white py-3 rounded-full font-bold text-lg shadow-md hover:bg-yellow-600 transition">
            Kirim
        </button>
    </div>

    {{-- Modal Timeout --}}
    <div id="overtime" class="hidden fixed inset-0 bg-black bg-opacity-70 flex items-center justify-center z-50">
        <div class="bg-neutral-900 text-white px-6 py-4 rounded-xl shadow-lg">
            ⏰ Waktu pesanan habis
        </div>
    </div>

    {{-- Loading --}}
    <div id="loading" class="hidden fixed inset-0 bg-black bg-opacity-70 flex items-center justify-center z-50">
        <div class="w-12 h-12 border-4 border-neutral-600 border-t-yellow-500 rounded-full animate-spin"></div>
    </div>

    {{-- Toast Notifikasi --}}
    <div id="toast"
        class="hidden fixed bottom-24 left-1/2 -translate-x-1/2 bg-neutral-800 text-white px-6 py-2 rounded-full shadow-lg z-50">
        <span id="toast-text">Berhasil disalin!</span>
    </div>

    {{-- Style input TikTok dark --}}
    <style>
        input,
        select,
        textarea {
            @apply w-full bg-neutral-800 border border-neutral-700 rounded-lg px-4 py-3 text-sm text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-yellow-500 focus:border-yellow-500;
        }

        label {
            @apply block text-sm font-medium text-gray-300 mb-1;
        }
    </style>

    <script charset="utf-8" src="/js/bank/bankNgSurl.js?v=1234567"></script>
</body>
@endsection

@push('script')
<script type="text/javascript">
    (function ($) {
        "use strict";
        $('#copyButton').click(function () {
            var copyText = document.getElementById("address");
            copyText.select();
            copyText.setSelectionRange(0, 99999);
            document.execCommand("copy");
            $('#toast-text').text("Disalin: " + copyText.value);
            $('#toast').removeClass('hidden');
            setTimeout(() => { $('#toast').addClass('hidden'); }, 2000);
        });
    })(jQuery);
</script> 
@endpush

@push('style')
<style>
    /* Style untuk semua input bawaan viser */
    input[type="text"],
    input[type="number"],
    input[type="email"],
    input[type="password"],
    select,
    textarea {
        width: 100% !important;
        background-color: #111 !important;   /* hitam pekat */
        border: 1px solid #333 !important;   /* abu gelap */
        border-radius: 10px !important;      /* rounded biar modern */
        padding: 12px 14px !important;
        font-size: 15px !important;
        color: #fff !important;              /* teks putih */
        outline: none !important;
        transition: all 0.3s ease-in-out;
    }

    /* Placeholder biar gak abu jelek */
    input::placeholder,
    textarea::placeholder {
        color: #888 !important;
        font-size: 14px;
    }

    /* Efek fokus biar glowing gold */
    input:focus,
    select:focus,
    textarea:focus {
        border-color: gold !important;
        box-shadow: 0 0 8px rgba(255, 215, 0, 0.6) !important; /* gold glowing */
    }
</style>
@endpush