@extends($activeTemplate.'layouts.master')
@section('content')

<body class="tiktok-theme">   
<!-- TABBAR ATAS PROFIL -->
<div class="top-tabbar-profile">
    <div class="top-title">Profil</div>
</div>
<div class="profile-header">    
    <div class="avatar">    
        <img src="{{asset('core/img/tiktok.jpg')}}" alt="avatar">    
    </div>    
    <h3 class="username">+62 {{ $user->username }}</h3>    
    <p class="userid">ID : {{ auth()->user()->id }}</p>    
</div>  

<div class="profile-section container">    

    <div class="wallet-card">    
        <div>    
            <p>Dompet Isi Ulang</p>    
            <h3>Rp{{ number_format(auth()->user()->deposit_wallet, 0, ',', '.') }}</h3>    
        </div>    
        <div>    
            <p>Dompet Komisi</p>    
            <h3>Rp{{ number_format(auth()->user()->interest_wallet, 0, ',', '.') }}</h3>    
        </div>    
    </div>  

    <div class="stats-card">    
        <ul>    
            <li>    
                <label>Produk Maksimal</label>    
                <span>Rp{{ number_format(auth()->user()->deposit_wallet, 0, ',', '.') }}</span>    
            </li>    
            <li>    
                <label>Total Saldo</label>    
                <span>Rp{{ number_format(auth()->user()->interest_wallet, 0, ',', '.') }}</span>    
            </li>    
            <li>    
                <label>Komisi Hari Ini</label>    
                <span>Rp{{ number_format(auth()->user()->interest_wallet, 0, ',', '.') }}</span>    
            </li>    
        </ul>    
    </div>    

    @php
    $authUser = Auth::user();
    $userCount = App\Models\User::where('ref_by', $authUser->id)->count();
    $referralCommission = App\Models\Transaction::where('user_id', $authUser->id)
        ->where('remark', 'referral_commission')
        ->sum('amount');
    @endphp

    <div class="team-card">    
        <ul>    
            <li>    
                <label>Total Tim</label>    
                <span>{{ $userCount }}</span>    
            </li>    
            <li>    
                <label>Komisi Tim</label>    
                <span>Rp{{ number_format($referralCommission, 0, ',', '.') }}</span>    
            </li>    
            <li>    
                <label>Komisi Hari Ini</label>    
                <span>Rp{{ number_format(auth()->user()->interest_wallet, 0, ',', '.') }}</span>    
            </li>    
        </ul>    
    </div>    

    <div class="menu-grid">    
        <a href="{{route('user.withdraw.history')}}">    
            <img src="{{asset('core/img/m_11.png')}}" class="gold-icon" alt="">    
            <p class="gold-text">Riwayat Penarikan</p>    
        </a>    
        <a href="{{route('user.deposit.history')}}">    
            <img src="{{asset('core/img/m_13.png')}}" class="gold-icon" alt="">    
            <p class="gold-text">Riwayat Isi Saldo</p>    
        </a>    
        <a href="{{route('user.invest.log')}}">    
            <img src="{{asset('core/img/m_12.png')}}" class="gold-icon" alt="">    
            <p class="gold-text">Gaji Saya</p>    
        </a>    
        <a href="{{ route('user.invest.ranking') }}">    
            <img src="{{asset('core/img/m_8.png')}}" class="gold-icon" alt="">    
            <p class="gold-text">Peringkat Pengguna</p>    
        </a>    
        <a href="{{ route('user.change.password') }}">    
            <img src="{{asset('core/img/m_3.png')}}" class="gold-icon" alt="">    
            <p class="gold-text">Ganti Password</p>    
        </a>    
        <a href="https://t.me/ng_scripts">    
            <img src="{{asset('core/img/m_5.png')}}" class="gold-icon" alt="">    
            <p class="gold-text">Download Aplikasi</p>    
        </a>    
        <a href="{{route('user.logout')}}">    
            <img src="{{asset('core/img/m_6.png')}}" class="gold-icon" alt="">    
            <p class="gold-text">Keluar</p>    
        </a>    
    </div>
</div>  

<a href="https://wa.me/6285808545268" class="floating-btn">    
    <img src="{{asset('core/img/ico-service.png')}}" alt="">    
</a>  

</body>    
@endsection  

@push('style')  
<style>    
body.tiktok-theme {    
    background:#000;    
    color:#fff;    
    font-family:'Maven Pro', sans-serif;    
    padding-bottom: 120px;    
}     
/* TABBAR PROFIL - gaya sama kayak dashboard */
.top-tabbar-profile {
    background: #222 !important;
  color: #fff !important;
  text-align: center;
  font-size: 14px;
  font-weight: 600;
  padding: 14px 0;
  border-bottom: 2px solid gold;
  border-radius: 0 0 30px 30px;
  box-shadow: 0 3px 10px rgba(255, 215, 0, 0.4);
  margin-bottom: 18px;
}

.top-tabbar-profile .top-title {
    margin: 0;
}
.profile-header {    
    padding:40px 20px 20px;    
    text-align:center;    
    border-bottom:1px solid rgba(255,255,255,0.1);    
}    

.profile-header .avatar img {    
    width:80px;    
    height:80px;    
    border-radius:50%;    
    border:3px solid gold;    
}    

.username {    
    margin-top:10px;    
    font-size:18px;    
    font-weight:600;    
}    

.userid {    
    font-size:14px;    
    color:#aaa;    
}    

.container {    
    padding:20px 15px;    
}    

.wallet-card {    
    display:flex;    
    justify-content:space-between;    
    background:#111;    
    border-radius:16px;    
    padding:20px;    
    margin-bottom:20px;    
}    

.wallet-card p {    
    font-size:13px;    
    color:#aaa;    
    margin:0;    
}    

.wallet-card h3 {    
    margin:5px 0 0;    
    font-size:16px;    
}    

.stats-card, .team-card {    
    background:#111;    
    border-radius:16px;    
    padding:20px;    
    margin-bottom:20px;    
}    

.stats-card ul, .team-card ul {    
    display:flex;    
    justify-content:space-around;    
    text-align:center;    
}    

.stats-card li, .team-card li { flex:1; }    

.stats-card label, .team-card label {    
    display:block;    
    font-size:12px;    
    color:#aaa;    
}    

.stats-card span, .team-card span {    
    display:block;    
    font-size:16px;    
    font-weight:600;    
    color:gold;    
    margin-top:5px;    
    white-space: nowrap;    
}    

/* Versi grid TikTok rapi */    
.menu-grid {    
    display: grid;    
    grid-template-columns: repeat(3, 1fr);    
    gap: 15px;    
    justify-items: center;    
}    

.menu-grid a {    
    background: #111;    
    border-radius: 16px;    
    padding: 15px 5px;    
    text-align: center;    
    display: flex;    
    flex-direction: column;    
    align-items: center;    
    width: 100px;    
}    

.menu-grid img {    
    width: 35px;    
    height: 35px;    
    margin-bottom: 8px;    
}    

.menu-grid p {    
    font-size: 12px;    
    margin: 0;    
    color: #fff;    
}    

/* Icon PNG emas */    
.gold-icon {    
    filter: brightness(0) saturate(100%) invert(74%) sepia(55%) saturate(447%) hue-rotate(7deg) brightness(97%) contrast(92%);    
    transition: all .3s ease;    
}    

/* baris terakhir center kalau ganjil */    
.menu-grid a:last-child:nth-child(odd) {    
    grid-column: 2;    
}   

.floating-btn {    
    position:fixed;    
    bottom:120px;    
    right: 10px;    
    width:60px;    
    height:60px;    
    background:#ff0050;    
    border-radius:50%;    
    display:flex;    
    align-items:center;    
    justify-content:center;    
    box-shadow:0 4px 12px rgba(0,0,0,.5);     
    z-index:9999 ;    
}    

.floating-btn img {    
    width:28px;    
    height:28px;    
}     
</style> 
@endpush