@extends('admin.layouts.app')

@section('content')
<div class="container py-4">
    <h3 class="mb-3 text-warning">{{ $pageTitle }}</h3>
    
    <div class="card border-warning shadow-sm">
        <div class="card-body">
            <h5 class="card-title text-gold">Kode Bonus: <span class="text-light">{{ $data->code }}</span></h5>
            <p><strong>Nama Bonus:</strong> {{ $data->bonus_name }}</p>
            <p><strong>Nominal Bonus:</strong> Rp {{ number_format($data->amount, 0, ',', '.') }}</p>
            <p><strong>Status:</strong> 
                <span class="{{ $data->status == 'active' ? 'text-success' : 'text-danger' }}">
                    {{ ucfirst($data->status) }}
                </span>
            </p>
            <p><strong>Jumlah Pemenang:</strong> {{ $data->winner }}</p>
            <p><strong>Dibuat pada:</strong> {{ $data->created_at }}</p>

            <a href="{{ route('admin.bonus.index') }}" class="btn btn-secondary mt-3">← Kembali</a>
        </div>
    </div>
</div>
@endsection