@extends('admin.layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h5>{{ $data ? __('Edit Bonus') : __('Add Bonus') }}</h5>
    </div>
    <div class="card-body">
        <form action="{{ route('admin.bonus.insert') }}" method="POST">
            @csrf
            <input type="hidden" name="id" value="{{ $data->id ?? '' }}">
            <div class="mb-3">
                <label class="form-label">@lang('Bonus Name')</label>
                <input type="text" name="bonus_name" class="form-control" value="{{ $data->bonus_name ?? old('bonus_name') }}" required>
            </div>
            <div class="mb-3">
                <label class="form-label">@lang('Code')</label>
                <input type="text" name="code" class="form-control" value="{{ $data->code ?? old('code') }}" required>
            </div>
            <div class="mb-3">
                <label class="form-label">@lang('Amount')</label>
                <input type="number" name="amount" class="form-control" value="{{ $data->amount ?? old('amount') }}" required>
            </div>
            <div class="mb-3">
                <label class="form-label">@lang('Winner')</label>
                <input type="number" name="winner" class="form-control" value="{{ $data->winner ?? old('winner') }}" required>
            </div>
            <div class="mb-3">
                <label class="form-label">@lang('Service Counter')</label>
                <input type="number" name="set_service_counter" class="form-control" value="{{ $data->set_service_counter ?? old('set_service_counter') }}" required>
            </div>
            <button type="submit" class="btn btn-primary">@lang($data ? 'Update' : 'Create')</button>
        </form>
    </div>
</div>
@endsection