@extends('admin.layouts.app')

@section('content')
<div class="card">
    <div class="card-header">
        <h5>@lang('Bonus List')</h5>
    </div>
    <div class="card-body">
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>@lang('ID')</th>
                    <th>@lang('Bonus Name')</th>
                    <th>@lang('Code')</th>
                    <th>@lang('Amount')</th>
                    <th>@lang('Winner')</th>
                    <th>@lang('Service Counter')</th>
                    <th>@lang('User')</th>
                    <th>@lang('Status')</th>
                </tr>
            </thead>
            <tbody>
                @forelse($datas as $data)
                <tr>
                    <td>{{ $data->id }}</td>
                    <td>{{ $data->bonus->bonus_name ?? '-' }}</td>
                    <td>{{ $data->bonus->code ?? '-' }}</td>
                    <td>{{ $data->bonus->amount ?? '-' }}</td>
                    <td>{{ $data->bonus->winner ?? '-' }}</td>
                    <td>{{ $data->bonus->set_service_counter ?? '-' }}</td>
                    <td>{{ $data->user->name ?? '-' }}</td>
                    <td>{{ $data->bonus->status ?? '-' }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="8" class="text-center">@lang('No data found')</td>
                </tr>
                @endforelse
            </tbody>
        </table>
        <a href="{{ route('admin.bonus.index') }}" class="btn btn-secondary mt-2">@lang('Back')</a>
    </div>
</div>
@endsection