<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Bonus;
use App\Models\BonusLedger;
use Illuminate\Http\Request;

class BonusController extends Controller
{
    public $route = 'admin.bonus';

    // List semua bonus
    public function index()
    {
        $datas = Bonus::orderByDesc('id')->get();
        $pageTitle = 'Manage Bonus';
        return view('admin.pages.bonus.index', compact('datas', 'pageTitle'));
    }

    // List user yang menggunakan bonus
    public function bonuslist()
    {
        $datas = BonusLedger::with(['user', 'bonus'])->orderByDesc('id')->get();
        $pageTitle = 'Bonus List';
        return view('admin.pages.bonus.bonuslist', compact('datas', 'pageTitle'));
    }

    // Activate bonus
    public function status($id)
    {
        $data = Bonus::findOrFail($id);
        Bonus::query()->update(['status' => 'inactive']);
        $data->status = 'active';
        $data->save();

        return redirect()->route($this->route . '.index')->with('success', 'Successfully activated bonus.');
    }

    // Form Add / Edit
    public function create($id = null)
    {
        $data = $id ? Bonus::find($id) : null;
        $pageTitle = $id ? 'Edit Bonus' : 'Add Bonus';
        return view('admin.pages.bonus.insert', compact('data', 'pageTitle'));
    }

    // Lihat detail bonus
    public function view($id)
    {
        $data = Bonus::findOrFail($id);
        $pageTitle = 'View Bonus';
        return view('admin.pages.bonus.view', compact('data', 'pageTitle'));
    }

    // Simpan / update bonus
    public function insert_or_update(Request $request)
    {
        $request->validate([
            'bonus_name' => 'required|string|max:100',
            'set_service_counter' => 'required|numeric',
            'code' => 'required|string|max:50',
            'amount' => 'required|numeric',
            'winner' => 'required|numeric',
        ]);

        $bonus = $request->id ? Bonus::findOrFail($request->id) : new Bonus();
        $bonus->bonus_name = $request->bonus_name;
        $bonus->set_service_counter = $request->set_service_counter;
        $bonus->code = $request->code;
        $bonus->amount = $request->amount;
        $bonus->winner = $request->winner;
        $bonus->save();

        return redirect()->route($this->route . '.index')
            ->with('success', $request->id ? 'Bonus updated successfully.' : 'Bonus created successfully.');
    }

    // Delete bonus
    public function delete($id)
    {
        $bonus = Bonus::findOrFail($id);
        $bonus->delete();

        return redirect()->route($this->route . '.index')->with('success', 'Bonus deleted successfully.');
    }
}